// SC300Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC300.h"
#include "SC300Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

// DEBUG PATCH PROGRAM
//
VOID SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC330] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", 0x00000000 );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 10 + 1, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

ULONG  g_b_start_statsticis = FALSE;

ULONG  g_n_video_frame_number[ 4 ];

double g_d_video_start_sample_time[ 4 ];

double g_d_video_stop_sample_time[ 4 ];

ULONG  g_n_audio_sample_number[ 4 ];

double g_d_audio_start_sample_time[ 4 ];

double g_d_audio_stop_sample_time[ 4 ];

BOOL on_process_video_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG		i = nChannelNumber - 1;

	CSC300Dlg *	pMainDialog = (CSC300Dlg *)(pUserData);

	// 5.0 YOU CAN ACCESS YUY2 VIDEO FRAME BUFFER FROM PBUFFER POINTER HERE.
	//
	{
		// ...
	}

	// DEBUG PATCH PROGRAM
	// 
	if( (g_b_start_statsticis) && (i == 0) ) {

		if( g_n_video_frame_number[ i ] == 0 ) {

			g_d_video_start_sample_time[ i ] = dSampleTime;
		}
		g_d_video_stop_sample_time[ i ] = dSampleTime;

		g_n_video_frame_number[ i ]++;
	}
	return TRUE;
}

BOOL on_process_audio_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG		i = nChannelNumber - 1;

	CSC300Dlg *	pMainDialog = (CSC300Dlg *)(pUserData);

	// 5.0 YOU CAN ACCESS PCM AUDIO DATA FROM PBUFFER POINTER NOW.
	{
		// ...
	}

	// DEBUG PATCH PROGRAM
	// 
	if( (g_b_start_statsticis) && (i == 0) ) {

		if( g_n_audio_sample_number[ i ] == 0 ) {

			g_d_audio_start_sample_time[ i ] = dSampleTime;
		}
		g_d_audio_stop_sample_time[ i ] = dSampleTime;

		g_n_audio_sample_number[ i ] += nBufferLen / 4;
	}
	return FALSE;
}

BOOL on_process_video_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg dialog

CSC300Dlg::CSC300Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC300Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC300Dlg)
	m_bIsEnableDeinterlace = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC300Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC300Dlg)
	//DDX_Control(pDX, IDC_STATIC_PREVIEW_WINDOW_04, m_oDisplayWindowCH04);
	//DDX_Control(pDX, IDC_STATIC_PREVIEW_WINDOW_03, m_oDisplayWindowCH03);
	//DDX_Control(pDX, IDC_STATIC_PREVIEW_WINDOW_02, m_oDisplayWindowCH02);
	DDX_Control(pDX, IDC_STATIC_PREVIEW_WINDOW_01, m_oDisplayWindowCH01);
	DDX_Control(pDX, IDC_STATIC_DEBUG, m_staticDebugCtrl);
	DDX_Check(pDX, IDC_CHECK_DEINTERLACE, m_bIsEnableDeinterlace);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC300Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC300Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CHECK_DEINTERLACE, OnCheckDeinterlace)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg message handlers

BOOL CSC300Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_bIsEnableDeinterlace = FALSE;
	
	UpdateData( FALSE );

	// 1.0 INITIALIZE COM DATABASE
	//
	HRESULT hr = CoInitialize( NULL );

	// 2.0 CREATE VIDEO DEVICES
	//
	for( ULONG i = 0 ; i < 4 ; i++ ) {

		PF_BUFFER_CALLBACK bcb_video[ 4 ] = { on_process_video_buffer_CH01, 
			
											  on_process_video_buffer_CH02, 
												
											  on_process_video_buffer_CH03, 
												
											  on_process_video_buffer_CH04 };

		PVOID params[ 4 ] = { this, this, this, this };

		PVOID params[ 4 ] = { this, this, this, this };

		//HWND hwnds[ 4 ] = { m_oDisplayWindowCH01.m_hWnd,

		//					m_oDisplayWindowCH02.m_hWnd,

		//				    m_oDisplayWindowCH03.m_hWnd,

		//					m_oDisplayWindowCH04.m_hWnd };

		HWND hwnds[ 4 ] = { m_oDisplayWindowCH01.m_hWnd,

							NULL,

						    NULL,

							NULL };

		if( m_oAnalogDeviceVideoGraphs[ i ].Create( L"MZ0380 PCI", i, bcb_video[ i ], params[ i ], hwnds[ i ] ) == FALSE ) {

			m_oAnalogDeviceVideoGraphs[ i ].Close();
		}

//#ifdef DEFAULT_STD_NTSC // NTSC

//		m_oAnalogDeviceVideoGraphs[ i ].SetStandard( KS_AnalogVideo_NTSC_M );

//		m_oAnalogDeviceVideoGraphs[ i ].SetFormat( MAKEFOURCC('Y', 'U', 'Y', '2'), 720, 480, 16, 29.970 );
//#endif

//#ifdef DEFAULT_STD_PAL // PAL

//		m_oAnalogDeviceVideoGraphs[ i ].SetStandard( KS_AnalogVideo_PAL_B );

//		m_oAnalogDeviceVideoGraphs[ i ].SetFormat( MAKEFOURCC('Y', 'U', 'Y', '2'), 720, 576, 16, 25.000 );
//#endif

		m_oAnalogDeviceVideoGraphs[ i ].SetFormat( MAKEFOURCC('Y', 'V', '1', '2'), 1920, 1080, 12, 60 ); // HD

		m_oAnalogDeviceVideoGraphs[ i ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 1 /*WEAVE*/ );
	}

	m_oAnalogDeviceVideoGraphs[ 0 ].SetFormat( MAKEFOURCC('Y', 'V', '1', '2'), 3840, 2160, 12, 60 ); // HD

	// 4k surround capture

	SC_DEBUG("------------------>");

	m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 610, 4);

	m_oAnalogDeviceVideoGraphs[ 1 ].SetCustomProperty( 610, 1);

	m_oAnalogDeviceVideoGraphs[ 2 ].SetCustomProperty( 610, 1);

	m_oAnalogDeviceVideoGraphs[ 3 ].SetCustomProperty( 610, 1);


	m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 611, 0);

	m_oAnalogDeviceVideoGraphs[ 1 ].SetCustomProperty( 611, 1920);

	m_oAnalogDeviceVideoGraphs[ 2 ].SetCustomProperty( 611, 0);

	m_oAnalogDeviceVideoGraphs[ 3 ].SetCustomProperty( 611, 1920);


	m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 612, 0);

	m_oAnalogDeviceVideoGraphs[ 1 ].SetCustomProperty( 612, 0);

	m_oAnalogDeviceVideoGraphs[ 2 ].SetCustomProperty( 612, 1080);

	m_oAnalogDeviceVideoGraphs[ 3 ].SetCustomProperty( 612, 1080);

	//DISABLE SUB
	m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 273, 0);

	m_oAnalogDeviceVideoGraphs[ 1 ].SetCustomProperty( 273, 0);

	m_oAnalogDeviceVideoGraphs[ 2 ].SetCustomProperty( 273, 0);

	m_oAnalogDeviceVideoGraphs[ 3 ].SetCustomProperty( 273, 0);

	ULONG RESOLUTION = ( 3840 << 16 ) | ( 2160 << 0 );

	m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 233, RESOLUTION);

	SC_DEBUG("<------------------");

	// 3.0 CREATE ADUIO DEVICES
	//
	for( i = 0 ; i < 4 ; i++ ) {

		PF_BUFFER_CALLBACK bcb_audio[ 4 ] = { on_process_audio_buffer_CH01, 
			
											  on_process_audio_buffer_CH02, 
												
											  on_process_audio_buffer_CH03, 
												
											  on_process_audio_buffer_CH04 };

		PVOID params[ 4 ] = { this, this, this, this };

		if( m_oAnalogDeviceAudioGraphs[ i ].Create( L"MZ0380 PCI", i, bcb_audio[ i ], params[ i ] ) == FALSE ) {

			m_oAnalogDeviceAudioGraphs[ i ].Close();
		}
		m_oAnalogDeviceAudioGraphs[ i ].SetFormat( 2, 16, 48000 ); // SDI IS ALWAYS STEREO/16BIS/48000HZ
	}

	// DEBUG PATCH PROGRAM
	// 
	for( i = 0 ; i < 4 ; i++ ) {

		g_n_video_frame_number[ i ] = 0;

		g_d_video_start_sample_time[ i ] = 0;

		g_d_video_stop_sample_time[ i ] = 0;

		g_n_audio_sample_number[ i ] = 0;

		g_d_audio_start_sample_time[ i ] = 0;

		g_d_audio_stop_sample_time[ i ] = 0;
	}

	// 4.0 RUN VIDEO & AUDIO DEVICES
	//
	for( i = 0 ; i < 1 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Run(); }

	for( i = 0 ; i < 1 ; i++ ) { m_oAnalogDeviceAudioGraphs[ i ].Run(); }
	
	// DEBUG PATCH PROGRAM
	// 
	{	g_b_start_statsticis = TRUE;

		SetTimer( 0x00000000, 1000, NULL );
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC300Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	ULONG i = 0;

	KillTimer( 0x00000000 );

	// 6.0 RESET DEVICE PROPERTY
	//
	for( i = 0 ; i < 4 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 1 /*WEAVE*/ ); }

	// 7.0 STOP & CLOSE DEVICES
	//
	for( i = 0 ; i < 1 ; i++ ) { m_oAnalogDeviceAudioGraphs[ i ].Stop(); }

	for( i = 0 ; i < 1 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Stop(); }

	for( i = 0 ; i < 4 ; i++ ) { m_oAnalogDeviceAudioGraphs[ i ].Close(); }

	for( i = 0 ; i < 4 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Close(); }

	// 8.0 CLOSE COM DATABASE
	//
	CoUninitialize();
}

void CSC300Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC300Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC300Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSC300Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CSC300Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CSC300Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		CHAR psz[ MAX_PATH << 2 ] = "";

		// GET VIDEO LOCK/UNLOCK STATUS
		// 
//		for( ULONG i = 0 ; i < 4 ; i++ ) {

//			ULONG nLock = 0x00000000;

//			m_oAnalogDeviceVideoGraphs[ i ].GetLock( &nLock );

//			StringCbPrintfA( psz + strlen(psz), MAX_PATH, "CH%02d:        %d, ", i + 1, nLock  );

//			if( i % 4 == 3 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH, "( VIDEO LOCK STATUS )\n" ); }
//		}

		// DUMP VIDEO FRAMERATE
		//
		for(ULONG i = 0 ; i < 1 ; i++ ) {

			if( g_d_video_stop_sample_time[ i ] > g_d_video_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d: %8d, ", i + 1, (UINT)((g_n_video_frame_number[ i ] * 1000000.0) / (g_d_video_stop_sample_time[ i ] - g_d_video_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d: %8d, ", i + 1, 0 );
			}
			//if( i % 4 == 3 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO FPS * 1000000 )\n" ); }
			StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO FPS * 1000000 )\n" );
		}

		// DUMP ADUIO SAMPLE RATE
		//
		for( i = 0 ; i < 1 ; i++ ) {

			if( g_d_audio_stop_sample_time[ i ] > g_d_audio_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d: %8d, ", i + 1, (UINT)((g_n_audio_sample_number[ i ] * 1000.0) / (g_d_audio_stop_sample_time[ i ] - g_d_audio_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d: %8d, ", i + 1, 0 );
			}
			//if( i % 4 == 3 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( AUDIO SPS * 1000 )\n" ); }
			StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( AUDIO SPS * 1000 )\n" );
		}
		m_staticDebugCtrl.SetWindowText( psz );
	}
	CDialog::OnTimer(nIDEvent);
}

void CSC300Dlg::OnCheckDeinterlace() 
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );

	if( m_bIsEnableDeinterlace == TRUE ) {

		m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 1 /*BLEND*/ );

		m_oAnalogDeviceVideoGraphs[ 1 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 1 /*BLEND*/ );

		m_oAnalogDeviceVideoGraphs[ 2 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 1 /*BLEND*/ );

		m_oAnalogDeviceVideoGraphs[ 3 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 1 /*BLEND*/ );
	}
	else {

		m_oAnalogDeviceVideoGraphs[ 0 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 0 /*WEAVE*/ );

		m_oAnalogDeviceVideoGraphs[ 1 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 0 /*WEAVE*/ );

		m_oAnalogDeviceVideoGraphs[ 2 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 0 /*WEAVE*/ );

		m_oAnalogDeviceVideoGraphs[ 3 ].SetCustomProperty( 200 /*KSPROPERTY_CUSTOM_XET_ANALOG_VIDEO_DEINTERLACE_TYPE*/, 0 /*WEAVE*/ );
	}
}
